#!/bin/bash

EMAILTO=$1
EMAILCC=$2
EMAILSUBJECT=$3
EMAILBODY=$4
EMAILATTACHMENTURI=$5
EMAILATTACHMENTNAMEUTF8=$6

HCS12_STATUS_SENDING=1
HCS12_STATUS_TOO_LARGE=3
HCS12_STATUS_SENT=4
HCS12_STATUS_FAILED_TO_SEND=5

echo "::ES::$HCS12_STATUS_SENDING"

#########################################
# Clean up from the last sent email
rm email.content
rm email.result
rm email.output
touch email.content
touch email.result


# extract the email filename 

# by default this gives size in KB
SIZE=$(du -s "$EMAILATTACHMENTURI" | awk '{ print $1 }')

echo "::INF::Filesize $SIZE KB"

if ((SIZE<10000)) ; then 
	echo "::INF::Attachment size OK"; 
else 
	echo "::ES::$HCS12_STATUS_TOO_LARGE"
	echo "::INF::Attachment is greater than 10MB";
	echo 1 > email.result
	exit 1
fi

# Base 64 encode the files and strip out all the newlines
# Our CCU version of base64 doesnt support the -w 0 command so we pipe to 'tr' 
BASE64FILE="$(base64 "$EMAILATTACHMENTURI" | tr -d '\n')"

# If no email body is set lets just set it to nothing
if [ -z "$EMAILBODY" ]
then
	EMAILBODY=" "
fi

# If no email subject is set lets just set it to nothing
if [ -z "$EMAILSUBJECT" ]
then
	EMAILSUBJECT=" "
fi

# Generate an email content file as we cant fit it all on a command line, this is a JSON structure
# The definition can be found here: https://sendgrid.com/docs/API_Reference/Web_API_v3/Mail/index.html 

#echo "'" >> email.content

if [ -z "$EMAILCC" ]
then
	# No CC address set
	echo '{"personalizations":[{"to":[{"email":"'$EMAILTO'"}],"subject":"'$EMAILSUBJECT'"}],"from":{"email":"support@minicam.co.uk"},"content":[{"type":"text/plain","value":"'$EMAILBODY'"}],"attachments":[{"content":"' >> email.content
else
	echo '{"personalizations":[{"to":[{"email":"'$EMAILTO'"}],"cc":[{"email":"'$EMAILCC'"}],"subject":"'$EMAILSUBJECT'"}],"from":{"email":"support@minicam.co.uk"},"content":[{"type":"text/plain","value":"'$EMAILBODY'"}],"attachments":[{"content":"' >> email.content
fi

echo $BASE64FILE >> email.content
echo '","filename":"'$EMAILATTACHMENTNAMEUTF8'"}]}' >> email.content
#echo "'" >> email.content

# Send the email
rsp=`curl --insecure -s -i --request POST --url https://api.sendgrid.com/v3/mail/send --header 'Authorization: Bearer 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' --header 'Content-Type: application/json' -o email.output --data @email.content`

echo "::INF::Upload done"

# Lets check to see if the email was sent
RESULT=$(grep -c "HTTP/1.1 202" email.output)

if ((RESULT>0)) ; then 
	echo "::ES::$HCS12_STATUS_SENT"
	echo "::INF::Email sent to server"; 
	echo 0 > email.result
	exit 0
else 
	echo "::ES::$HCS12_STATUS_FAILED_TO_SEND"
	echo "::INF::Email failed to send";
	echo 2 > email.result
	exit 2
fi


