#!/bin/bash

args=("$@")

/etc/rc.d/init.d/smb stop

OF=/usr/lib/smb.conf
NAME=${args[0]}
IP="$(ifconfig wlan0 | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}')"
NETMASK="$(ifconfig wlan0 | grep 'Mask:' | cut -d: -f4 | awk '{ print $1}')"

sed -i "s/^netbios name = .*/netbios name = $NAME/g" $OF
sed -i "s/^server string = .*/server string = $NAME/g" $OF
sed -i "s/^interfaces = .*/interfaces = $IP\/$NETMASK/g" $OF

/etc/rc.d/init.d/smb start
