#!/bin/bash

#usage: ./startup.sh 16:32:12 20160301
#the timestamp should be 0 padded to make the string length the same
#the datestamp should be 0 padded to make the string length the same

echo "::SSINF::Script V1.0 Started"

#doDateCommand <timestamp> <datestamp>
function doDateCommand {
	#Check we have 2 parameters
	if [ $# -ne 2 ]; then
	  echo "::SSERR::Invalid number of parameters"
	  exit 1
	fi

	SETTIME=$1
	SETDATE=$2

	#Check string length
	#LENTIME=expr length $SETTIME
	#LENDATE=expr length $SETDATE

	LENTIME=${#SETTIME}
	LENDATE=${#SETDATE}

	if [ $LENTIME != 8 ]; then
	  echo "::SSERR::Invalid character count"
	  exit 1
	fi

	if [ $LENDATE != 8 ]; then
	  echo "::SSERR::Invalid character count"
	  exit 1
	fi

	#rough regex for time and date just to make sure no nasty characters are present
	#TIMEREGEX='^[0-2][0-9]:[0-5][0-9]:[0-5][0-9]'
	#DATEREGEX='^[0-9]{8}'
	#Seems like you cant use regex in bash, alternative would be to pipe to grep

	date "+%T %Y%m%d" -s "$SETTIME $SETDATE"
	OUT=$?
	if [ $OUT != 0 ]; then
	  echo "::SSERR::Date failed to set"
	  exit 1
	fi
}


if [ $1 != "bootloader" ]; then
	doDateCommand $1 $2
else
	echo "::SSINF::Skipping date cmd - bootloader"
fi

####################################################################################
####################################################################################

#Run One Of script and delete it after
OnceScript="./RunOnceScript.sh"
if [ -f $OnceScript ]; then
  $OnceScript
  rm $OnceScript
fi


#remount /tmp to get more space
mount -t tmpfs -o size=80M,mode=1777 /tmp


echo -e -n "\033[9]" > /dev/tty0
echo -e -n "\033[?25l" > /dev/tty0
echo -e -n "\033[9]" > /dev/tty1
modprobe ipu_prp_enc.ko
modprobe ipu_prp_vf_sdc.ko
modprobe ipu_prp_vf_sdc_bg.ko
modprobe ipu_still.ko
modprobe ipu_csi_enc.ko
modprobe TW9912_Proteus_tvin.ko
modprobe mxc_v4l2_capture
echo 0 > /sys/class/graphics/fb1/blank
echo "500" > /proc/sys/vm/dirty_writeback_centisecs
echo "200" > /proc/sys/vm/dirty_expire_centisecs
echo "95" > /proc/sys/vm/dirty_ratio
mount tmpfs /mnt/ramdisk -t tmpfs -o size=10m
echo 1 > /proc/sys/vm/lowmem_reserve_ratio
mknod /dev/ProteusFPHub c 61 0
chmod 666 /dev/ProteusFPHub
insmod ProteusFPHub_ext.ko
insmod /lib/modules/2.6.35.3-1129-g691c08a/kernel/drivers/misc/eeprom/at24.ko

#wifi related commands
modprobe cfg80211.ko
modprobe mac80211.ko
modprobe rtl8192cu.ko
/usr/local/sbin/wpa_supplicant -B -qq -i wlan0 -c /etc/wpa_supplicant/wifi.conf

echo "::SSOK::Startup Script finished"
exit 0

