#!/bin/bash

# $1 is the base directory/filename (without ext)
# $2 is the xml filename

rtfext='.rtf'
pdfext='.pdf'
psext='.ps'

rtffile=$1$rtfext
pdffile=$1$pdfext
psfile=$1$psext

echo "::INF::rtffile:"$rtffile
echo "::INF::pdffile:"$pdffile
echo "::INF::psfile:"$psfile

echo "::INF::----- Create Postscript"

sync # do a sync to make sure all files are present

./ted --saveTo "$rtffile" $psfile
rc=$? 
if [[ $rc != 0 ]]; then 
	echo "::ERR:: Postscript failed to create - code: $rc"
	exit $rc; 
fi

sync # lets make sure the .ps has been written 

echo "::INF::----- Create PDF"

./gs -sDEVICE=pdfwrite -o "$pdffile" $psfile
rc=$? 
if [[ $rc != 0 ]]; then 
	echo "::ERR:: PDF failed to create - code: $rc"
	exit $rc; 
fi

sync # lets make sure the pdf has been written

echo "::INF::----- PDF Done"

# mount -t vfat /dev/sda1 /mnt/mmc
# cp "$pdffile" /mnt/mmc
# cp "$2" /mnt/mmc
# umount /mnt/mmc
# echo "::INF::----- Copy to USB Done"

