#!/bin/bash


echo "::GSSINF::Get Latest build Started"

#switch display to CCU screen
exec >/dev/tty1 2>&1

########################## WIFI #########################################

if [ $1 == "WIFI" ]; then
    killall wpa_supplicant

    modprobe cfg80211.ko
    modprobe mac80211.ko
    modprobe rtl8192cu.ko
    /usr/local/sbin/wpa_supplicant -B -qq -i wlan0 -c ./wifi_boot.conf

    ifconfig wlan0 down
    ifconfig wlan0 up
    #iwconfig wlan0 essid "PROD_DEPLOY" key s:"bootloader" #doesn't work, so /etc/wpa_supplicant/wifi.conf has to be updated
    killall dhclient
    dhclient wlan0
    
    sleep 1

    #/usr/bin/smbclient '//DEPLOYMENT/public' -U pi%samba -c 'prompt OFF;recurse ON; mask ""; cd Test\PiotrTest; mget *' > /dev/tty1
    /usr/bin/smbclient '//192.168.1.50/public' -U pi%samba -c 'prompt OFF;recurse ON; mask ""; mget *' > /dev/tty1
fi


########################## USB #########################################
if [ $1 == "USB" ]; then
    mount /dev/sda1 /mnt/remusb0
    mount /dev/sdb1 /mnt/remusb1
    
    #only copy from "FilesToBeCopiedToCCU" folder, this will stop service and production from copying random files to CCU

    cp /mnt/remusb0/FilesToBeCopiedToCCU/* ./ -r
    cp /mnt/remusb1/FilesToBeCopiedToCCU/* ./ -r
fi

sync

echo "Script has finished restart will follow soon..." 

#sleep so user can spot the message before it goes restart
sleep 5

#switch display to back to console screen
exec >/dev/console 2>&1

#this will be picked by hcs12 and cause restart of the CCU
echo "::GSSOK::Startup Script finished"
exit 0

