#!/bin/bash
echo "Running RunOnceScript"

echo "Copying FSTAB"
mv ./fstab /etc/fstab

echo "Copying curl"

cp curl-binaries/curl /usr/bin/
cp curl-binaries/curl-config /usr/bin/
cp curl-binaries/libcurl.so.4.0.0 /usr/lib/

# make symlinks
ln -s /usr/lib/libcurl.so.4.0.0 /usr/lib/libcurl.so.4
ln -s /usr/lib/libcurl.so.4.0.0 /usr/lib/libcurl.so

# lets clean up the wincan cats - these are unsupported now
rm WinCan/WRC_MSCC-4-DOMESTIC-DRAIN-CODES_UK_ENG_SEC.xml
rm WinCan/WRC_MSCC-5-DOMESTIC-DRAIN-CODES_UK_ENG_SEC.xml
rm WinCan/WRC_NZPIM-2006-3_NZ_ENG_SEC.xml

# Redmine 332, remove extra files that might be created by Apple Mac unzip
rm WinCan/._*
rm ProPipe/._*

# lets replace factory if we have one
if [ -e factoryupdate.zip ]
then
	echo "Updating internal factory"
	
	# get rid of the existing factory
	rm -rf Firmware/~~factory
	
	# recreate the dir to unzip into
	mkdir Firmware/~~factory
	
	# unzip the new one into its location and cleanup the zip file
	# this is done in the background as it can take too long and disrupt the HCS12 expected boot time
	( unzip -q -o "factoryupdate.zip" -d "Firmware/~~factory/"; rm -rf factoryupdate.zip ) &
fi

echo "RunOnceScript finished"
exit 0
