#!/bin/bash

# $1 is the base directory/filename (without ext)

rtfext='.rtf'
pdfext='.pdf'
psext='.ps'

rtffile="$1$rtfext"
pdffile="$1$pdfext"
psfile="$1$psext"

pages=$2
width=$3

function checkpdf () {
	ret=$( grep -o "%PDF-1.5" "$pdffile" | wc -l )
	if [[ "$ret" != "1" ]]; then
		echo "::ERR:: [pdf] %!PS-Adobe-2.0 Not found"
		return 1;
	fi
	
	ret=$( grep -o "/Width $width" "$pdffile" | wc -l )
		if [[ "$ret" != "$pages" ]]; then
			if [[ "$ret" -gt "$pages" ]]; then
				# Thats ok the template must have some images the same width
				echo ""
			else
				echo "::ERR:: [pdf] Incorrect widths found"
				return 1;
			fi
	fi
	
	ret=$( grep -o "%%EOF" "$pdffile" | wc -l )
	if [[ "$ret" != "1" ]]; then
		echo "::ERR:: [pdf] %%EOF Not found"
		return 1;
	fi
	
	return 0
}

function checkpostscript () {
	ret=$( grep -o "%!PS-Adobe-2.0" "$psfile" | wc -l )
	if [[ "$ret" != "1" ]]; then
		echo "::ERR:: [ps] %!PS-Adobe-2.0 Not found"
		return 1;
	fi
	
	ret=$( grep -o "/Width $width" "$psfile" | wc -l )
		if [[ "$ret" != "$pages" ]]; then
		echo "::ERR:: [ps] Incorrect widths found"
		return 1;
	fi
	
	ret=$( grep -o "%%Pages: $pages" "$psfile" | wc -l )
	if [[ "$ret" != "1" ]]; then
		echo "::ERR:: [ps] Incorrect pages found"
		return 1;
	fi
	
	ret=$( grep -o "%%EOF" "$psfile" | wc -l )
	if [[ "$ret" != "1" ]]; then
		echo "::ERR:: [ps] %%EOF Not found"
		return 1;
	fi
	
	return 0
}

function convert () {
	sync # do a sync to make sure all files are present
	echo "::INF::----- Create Postscript"
	./ted --saveTo "$rtffile" "$psfile"
	rc=$? 
	if [[ $rc != 0 ]]; then 
		echo "::ERR:: Postscript failed to create - code: $rc"
		return 1
	fi

	sync # lets make sure the .ps has been written 

	echo "::INF::----- Create PDF"
	md5sum "$psfile"
	
	# Lets do some checking on the file 
	checkpostscript
	if [[ $? != 0 ]]; then 
		return 2
	fi

	./gs -sDEVICE=pdfwrite -o "$pdffile" "$psfile"
	rc=$? 
	if [[ $rc != 0 ]]; then 
		echo "::ERR:: PDF failed to create - code: $rc"
		return 3
	fi

	sync # lets make sure the pdf has been written
	
	# Lets do some checking on the file 
	checkpdf
	if [[ $? != 0 ]]; then 
		return 4
	fi

	return 0
}

function main () {

	echo "::INF:: *** Starting Conversion ***"
	echo "::INF:: $rtffile"
	echo "::INF:: $pdffile"

	md5sum "$rtffile"
	convert
	
	if [ $? != 0 ]; then
		# try a second time
		echo "::INF:: Conversion failed - Retrying..."
		convert
		if [ $? != 0 ]; then
			# try a third time
		 	echo "::INF:: Conversion failed - Retrying..."
			convert
		fi
	fi

	if [ $? != 0 ]; then	
		echo "::INF::----- PDF Failed"
	else
		md5sum "$pdffile"
		echo "::INF::----- PDF Done"
	fi

	# 26-6-17 SG removed the intermediate ps file
	rm "$psfile"
}

main
